/*
 *Written by Takashi Koizumi
 *Released under Creative Commons Licences
 *http://creativecommons.org/
 *http://creativecommons.org/licenses/by-nc-sa/2.1/jp/ 
 *
 */

var i = 0
var stcArray = new Array;// データ行収納用配列
var wrdArray = new Array; // 表示単語収納用配列
var rubi; //ルビ用変数
var fuku; //複合動詞用変数
var timerID; //切り替わり速度用変数
var reibun; //例文用変数
var rotateTime; //回転間隔時間
var doc;
var dataQuery;

$(document).ready(function(){
	doc = document.getElementById('QUERY'); //HTMLファイルから引きつがれたDOMを読み込む
	dataQuery = String(doc.src).split("?")[1]; //クエリ部分（データファイル名）のみを変数に入れる
	document.getElementById('deleteItem').disabled = true;//開始前「アイテムを表示しない」ボタンを非アクティブに
	document.getElementById('pause').disabled = true;//開始前「一時停止」ボタンを非アクティブに
	$.ajax({
		url: './data/' + dataQuery,
		type: 'get',
		success: function(data){
			stcArray =  data.split("\n"); //１行ごとに配列に入れる
			for (var ii = 0; ii < stcArray.length; ii = ii +1){ //外部データファイルの記述チェック
				if (stcArray[ii].match(/.*?#.*?#/) || stcArray[ii].match(/^[0-9]+/)){}
				else{
				alert("外部データファイル記述エラー\n\n" + dataQuery + "の" + (ii + 1) +"行目：「#」が足りません");
				}
			}
		}
	});
});

$(document).ready(function(){
	$("#CELL1").click(function(e){
		if (stcArray[0].match(/^[0-9]+/)){//外部ファイルに時間の記述があった場合の処理
			rotateTime = stcArray[0] * 1000; //配列の最初の行（回転時間）を秒に換算して変数に代入
			stcArray.splice(0,1);//回転時間の配列を消去
		}
		else{
			rotateTime = 5000; //外部ファイルに時間の記述がなければ、５秒に設定
		}
		document.getElementById('deleteItem').disabled = false;//開始後、「アイテムを表示しない」ボタンをアクティブに
		document.getElementById('pause').disabled = false;//開始後、「一時停止」ボタンをアクティブに
		clearTimeout(timerID);
		Loopstc();
		$( '#pause' ).button({
			label: '一時停止する'
		} );
	});
	$( '#deleteItem' ).button({ //「アイテムを表示しない」ボタンを押した処理
	enable:false
	})
	.click(function() {
			if(i > 0){
				i=i-1;
				}
			stcArray.splice(i,1);
			if (i > stcArray.length-1) { // stcArray.lengthは配列の数
				i = i -1;
				}
			clearTimeout(timerID);
			document.getElementById('deleteItem').disabled = true;
			$( '#pause' ).button({
				label: '一時停止する'
			} );
			Loopstc();
		});
	$( '#pause' ).button({ //ポーズボタンを押したときの処理
		enable:true
	})
	.click(function() {
			var options;
			if ($(this).text() == '一時停止する') {
				options = {
					label: '<font color=red>再開する</font>'
					};
				clearTimeout(timerID);
			} else {
				options = {
					label: '一時停止する'
				};
				Loopstc();
			}
			$(this).button('option', options);
		});
});

function Loopstc() {
	document.getElementById("COUNT").innerHTML=(i+1) + "/" + (stcArray.length);
	wrdArray = stcArray[i].split("#");
	if (i == stcArray.length-1) { // stcArray.lengthは配列の数
		i = 0;
	}
	else {
		i++;
	}
	timerID = setTimeout("Loopstc()", rotateTime); //メッセージの変わる速度（単位は千分の一秒）
	var rubiTemp = "<SPAN ID=\"TOP_LINE\">" + wrdArray[0] + "</SPAN><BR>";//フォントサイズを50%に
	var reibunTemp = "<SPAN ID=\"BOTTOM_LINE\">" + wrdArray[2] + "</SPAN><BR>";
	rubi = rubiTemp.replace(/<<(.+?)>>/g,"<SPAN ID=\"RED\">$1</SPAN>"); //フォントを赤に
	fuku = wrdArray[1].replace(/<<(.+?)>>/g,"<SPAN ID=\"RED\">$1</SPAN>"); //フォントを赤に
	reibun = reibunTemp.replace(/<<(.+?)>>/g,"<SPAN ID=\"RED\">$1</SPAN>"); //フォントを赤に
	flip1();
}

function flip1(){
	$("#CELL1").flip({//Flipさせられる要素
	direction: 'bt',//方向（bt,tb,lr,rl）
	bgColor: '#000000', //背景色
	color: '#2c5c47', //文字色
	speed: 400, //スピード
	content: '<br>' + rubi + fuku + '<br>' + reibun, //コンテンツ
	onEnd: function(){document.getElementById('deleteItem').disabled = false}
	});
}
